IF NOT EXISTS (
    SELECT i.index_id
    FROM sys.indexes i
    JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
    JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
    WHERE i.object_id = OBJECT_ID('dbo.EST_NFE_LOTE_SAI') 
        AND i.type_desc = 'NONCLUSTERED'
        AND (
            (c.name = 'CD_NFE_LOTE' AND ic.is_included_column = 0)
            OR (c.name = 'CD_NFE_LOTE_SAI' AND ic.is_included_column = 0)
            OR (c.name = 'CD_EMP' AND ic.is_included_column = 0)
			OR (c.name = 'CD_FILIAL' AND ic.is_included_column = 0)
			OR (c.name = 'CD_NF' AND ic.is_included_column = 0)
        )
		AND EXISTS (SELECT 1
					FROM sys.index_columns IC2
					WHERE iC2.object_id = ic.object_id AND iC2.index_id = ic.index_id
					GROUP BY iC2.object_id, iC2.index_id
					HAVING COUNT(1) = 5)
    GROUP BY i.object_id, i.index_id
)
BEGIN
    CREATE UNIQUE NONCLUSTERED INDEX [IX_EST_NFE_LOTE_SAI_NFSERVER_CD_NFE_LOTE] ON [dbo].[EST_NFE_LOTE_SAI]
(
	[CD_NFE_LOTE] ASC,
	[CD_NFE_LOTE_SAI] ASC,
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_NF] ASC
);
END



